//
//  GSComponent.h
//  Glyphs
//
//  Created by Georg Seifert on 30.3.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSTransformableElement.h>

typedef NS_ENUM(int8_t, GSImageType) {
	GSImageTypeUnknown = 0,
	GSImageTypePng,
	GSImageTypeTif,
	GSImageTypeJpg,
	GSImageTypeSvg,
};

/** GSBackgroundImage: The class defining the image

 It is a subclass of GSElement
 */
@interface GSBackgroundImage : GSTransformableElement {
	NSRect _crop;
}

/// @name Initialisation

/** Inits with a NSURL

 @param URL the URL
 */
- (instancetype)initWithURL:(NSURL *)URL;

- (instancetype)initWithData:(NSData *)imageData imageType:(GSImageType)imageType;

/// the image path
@property (strong, nonatomic) NSString *imagePath;
/// the image URL
@property (strong, nonatomic) NSURL *imageURL;
/// the NSImage
@property (readonly, nonatomic) NSImage *image;

@property (strong, nonatomic) NSData *imageData;

@property GSImageType imageType;

+ (GSImageType)imageTypeForFileExtension:(NSString *)fileExtension;

+ (NSString *)fileExtensionImageType:(GSImageType)imageType;

/// The Crop
@property (assign, nonatomic) NSRect crop;
/// transparency of rendering in outline mode.
@property (assign, nonatomic) unsigned short alpha;

- (BOOL)isEqualToBackgroundImage:(GSBackgroundImage *)other;

#ifndef GLYPHS_VIEWER
/// Shows the image in the Finder
- (void)showInFinder:(id)sender;

/// toggle locked
- (void)toggleLocked;
#endif

- (BOOL)hasValidImageToDraw;

- (BOOL)hasImageToDraw;

#ifndef GLYPHS_VIEWER
- (void)reloadImage;

- (void)updatePositionForSBIX;
#endif

@end
